<?php 

class config {
	
	private static $fields=array(
			'name'=>validator::REQUIRED,
			'description'=>validator::REQUIRED,
			'type'=>validator::REQUIRED,
			'enumvalues'=>validator::ANY,
			'minimum'=>validator::FLOAT,
			'maximum'=>validator::FLOAT,
			'defaultvalue'=>validator::ANY,
			'value'=>validator::ANY,
	);
	
	private static $helpTexts=array(
			'name'=>validator::REQUIRED,
			'description'=>validator::REQUIRED,
			'type'=>validator::REQUIRED,
			'enumvalues'=>validator::ANY,
			'minimum'=>validator::FLOAT,
			'maximum'=>validator::FLOAT,
			'defaultvalue'=>validator::ANY,
			'value'=>validator::ANY,
	);
	
	public static function getFieldValidations(){
		return self::$fields;
	}
	public static function getFieldHelpTexts(){
		return self::$helpTexts;
	}
	
	public static function canCreate(){
		return session::isAdmin();
	}

    /**
     * @param $id
     * @return mixed
     * @noinspection PhpUnusedParameterInspection
     */
    public static function canUpdate($id){
		return session::isAdmin();
	}
	
	static function get($name){
		$result=database::queryGetOne('SELECT value FROM config WHERE name=:name', array(':name'=>$name));
		if(!$result){ return null; }
		return trim($result['value']);
	}

    /**
     * @param $name
     * @param $value
     * @return bool
     * @throws BadRequestException
     * @throws ForbiddenException
     */
	public static function set($name, $value){
		if(!session::isAdmin()){ throw new ForbiddenException('Only administrators can see or change the configuration'); }
		$item=database::queryGetOne('SELECT * FROM config WHERE name=:name', array(':name'=>$name));
		if(!$item){ throw new BadRequestException('No config item called '.$name); }
		//TODO Validate!
		database::query('UPDATE config SET value=:value WHERE name=:name', array(':name'=>$name, ':value'=>trim($value)));
		return true;
	}

    /**
     * @param array $request
     * @return array|null
     * @throws ForbiddenException
     * @noinspection PhpUnusedParameterInspection
     */
	public static function getAll($request=array()){
		if(!session::isAdmin()){ throw new ForbiddenException('Only administrators can see the configuration'); }
		$result=database::queryGetAll('SELECT * FROM config ORDER BY name ', array());
		if(!$result){ return null; }
		return $result;
	}

    /**
     * @param $id
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	static function getById($id){
		throw new BadRequestException('getById not implemented on config');
	}

    /**
     * @param $name
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	static function getByName($name){
		throw new BadRequestException('getByName not implemented on config');
	}

    /**
     * @param $key
     * @param $value
     * @param array $request
     * @throws BadRequestException
     * @noinspection PhpUnusedParameterInspection
     */
	static function getByProperty($key,$value,$request=array()){
		throw new BadRequestException('getByProperty not implemented on config');
	}
	
	
	
}