<?php 

class basesession {
	
	protected static $session;
	
	public static $sharedProjectId;

    /**
     * @param $sessionObject
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function init($sessionObject){
		static::$session=$sessionObject;
		$now=time();
		$timeoutMins=config::get('auth_timeout_mins');
		$timeoutLimit=(int)(session::get('lastAccess'))+(60*$timeoutMins);
//		if($now>$timeoutLimit && session::isLoggedIn()){
//		    throw new AuthorizationRequiredException('Your session has expired. Please log in again.');
//		}
		session::$session->set('lastAccess',time());
		session::refreshProjectPermissions();
		if(session::isLoggedIn()){
			$sharedProject=project::getByName(project::SHARED);
			static::$sharedProjectId=$sharedProject['id'];
		}
	}

    /**
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function refreshProjectPermissions(){
		$isAdmin=false;
		$canCreateProjects=false;
		$canCreateUsergroups=false;
		$userId=session::getUserId();
		$ownProjects=array();
		$projectPermissions=array(
				'create'=>null,
				'read'  =>null,
				'update'=>null,
				'delete'=>null
		);
		$memberGroups=array();
		$visibleGroups=array();
		$visibleGroupIds=array();
		$memberGroupNames=array();
		$memberGroupIds=array();
		
		$userConfig=array(
		    'skin'=>'default'
		);
		
		if(!self::isLoggedIn()){
			//No permissions, nothing to do
		} else{
			$userId=session::getUserId();
			$memberGroups=database::queryGetAll('SELECT SQL_CALC_FOUND_ROWS ug.id, ug.name, ug.cancreateprojects, ug.cancreateusergroups, gm.isgroupadmin
				FROM usergroup AS ug, groupmembership AS gm
				WHERE ug.id=gm.usergroupid AND gm.userid=:userid',
					array(':userid'=>$userId)
			);
			$memberGroups=$memberGroups['rows'];
			if(empty($memberGroups)){
				$memberGroupIds=array();
				$memberGroupNames=array();
			} else {
				$memberGroupIds=array_column($memberGroups, 'id');
				$memberGroupNames=array_column($memberGroups, 'name');
			}
			
			if(self::isAdmin()){
				$visibleGroups=database::queryGetAll('SELECT SQL_CALC_FOUND_ROWS DISTINCT ug.id, ug.name, gm.isgroupadmin
				FROM usergroup AS ug LEFT JOIN groupmembership AS gm
				ON ug.id=gm.usergroupid',
						array()
				);
				$visibleGroups=$visibleGroups['rows'];
				$visibleGroupIds=array_column($visibleGroups, 'id');
				
				$projects=database::queryGetAll('SELECT SQL_CALC_FOUND_ROWS id FROM project',array());
				$projectIds=array_column($projects['rows'], 'id');
				$projectPermissions=array(
					'create'=>$projectIds,
					'read'  =>$projectIds,
					'update'=>$projectIds,
					'delete'=>$projectIds
				);
			} else {
				$visibleGroups=usergroup::getAll(array('pagesize'=>10000, 'pagenum'=>1));
				$visibleGroups=$visibleGroups['rows'];
				$visibleGroupIds=array_column($visibleGroups, 'id');
				
				$ownProjects=database::queryGetAll('SELECT SQL_CALC_FOUND_ROWS id FROM project WHERE owner=:userid',array(':userid'=>$userId));
				if(empty($ownProjects)){
					$ownProjectIds=array();
				} else {
					$ownProjectIds=array_column($ownProjects['rows'], 'id');
				}
				$projectPermissions=array(
					'create'=>$ownProjectIds,
					'read'  =>$ownProjectIds,
					'update'=>$ownProjectIds,
					'delete'=>$ownProjectIds
				);
				$permissions=database::queryGetAll('SELECT SQL_CALC_FOUND_ROWS proj.id AS projectid, perm.type AS type FROM project AS proj, permission AS perm, groupmembership AS gm 
						WHERE gm.userid=:userid AND gm.usergroupid=perm.usergroupid AND perm.projectid=proj.id
					',
					array(':userid'=>$userId)
				);
				if(!empty($permissions) && !empty($permissions['rows']) ){
					foreach($permissions['rows'] as $p){
						$projectPermissions[$p['type']][]=$p['projectid'];
					}
				}
			}
		}

		$isAdmin=in_array(usergroup::ADMINISTRATORS, $memberGroupNames);
		$canCreateProjects=$isAdmin;
		$canCreateUsergroups=$isAdmin;
		if(!empty($memberGroups)){
			foreach($memberGroups as $g){
				if(isset($g['cancreateprojects']) 	&& $g['cancreateprojects']){ $canCreateProjects=true; }
				if(isset($g['cancreateusergroups'])	&& $g['cancreateusergroups']){ $canCreateUsergroups=true; }
			}
		}
		
		session::set('projectPermissions',$projectPermissions);
		session::set('memberGroups',$memberGroups);
		session::set('memberGroupIds',$memberGroupIds);
		session::set('memberGroupNames',$memberGroupNames);
		session::set('visibleGroups',$visibleGroups);
		session::set('visibleGroupIds',$visibleGroupIds);
        session::set('isAdmin',$isAdmin);
        session::set('wasAdmin',$isAdmin);
		session::set('canCreateProjects',$canCreateProjects);
		session::set('canCreateUsergroups',$canCreateUsergroups);
		session::refreshUserConfig();
	}

    /**
     * @param $name
     * @return mixed
     */
	public static function get($name){
		return session::$session->get($name);
	}

    /**
     * @param $name
     * @param $value
     */
	public static function set($name, $value){
		session::$session->set($name, $value);
	}

    /**
     *
     */
	public static function destroy(){
		session::$session->destroy();
	}

	public static function getsessionId(){
		
	}

    /**
     * @return mixed
     */
	public static function isAdmin(){
		return session::$session->get('isAdmin');
	}

    /**
     * Temporarily become an administrator. This is needed in limited scenarios, where a user action
     * may result in files being added to a project that they cannot normally modify. It should be
     * used sparingly. Use session::revertAdmin() to return the admin status to what it was before.
     */
    public static function becomeAdmin(){
        $isAdmin=session::isAdmin();
        session::set('wasAdmin',$isAdmin);
        session::set('isAdmin',true);
    }

    /**
     * Revoke the session's administrator rights. This is needed mainly in test.
     * Use session::revertAdmin() to return the admin status to what it was before.
     */
    public static function revokeAdmin(){
        $isAdmin=session::isAdmin();
        session::set('wasAdmin',$isAdmin);
        session::set('isAdmin',false);
    }

    /**
     * Reverts the admin status to what it was before calling session::becomeAdmin() or session::revokeAdmin.
     */	
	public static function revertAdmin(){
	    $wasAdmin=session::get('wasAdmin');
	    session::set('isAdmin',$wasAdmin);
	}

    /**
     * @return mixed
     */
	public static function canCreateUsergroups(){
		return session::$session->get('canCreateUsergroups');
	}

    /**
     * @return mixed
     */
	public static function canCreateProjects(){
		return session::$session->get('canCreateProjects');
	}

    /**
     * @return bool
     */
	public static function isLoggedIn(){
		return !empty(session::$session->get('user'));
	}

    /**
     * @return mixed
     */
	public static function getUser(){
		return session::get('user');
	}

    /**
     * @return int
     */
	public static function getUserId(){
		$ret=session::get('userId');
		if($ret){ return $ret; }
		return 0;
	}

    /**
     * @return mixed
     */
	public static function getUsername(){
		return session::get('username');
	}

    /**
     * @return mixed
     */
	public static function getVisibleGroups(){
		return session::get('visibleGroups');
	}

    /**
     * @return mixed
     */
	public static function getVisibleGroupIds(){
		return session::get('visibleGroupIds');
	}

    /**
     * @return mixed
     */
	public static function getMemberGroups(){
		return session::get('memberGroups');
	}

    /**
     * @return mixed
     */
	public static function getMemberGroupIds(){
		return session::get('memberGroupIds');
	}

    /**
     * @param $request
     * @return array
     * @throws AuthorizationRequiredException
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function login($request){
		$username=@trim($request['username']);
		$password=@trim($request['password']);
		$rfid=@trim($request['rfid']);
		$error=false;
		$authenticatorType='database'; //LATER from config
		if(!empty($rfid)){
		    if(empty($username) && empty($password)){
		        try {
    		        $username=call_user_func_array($authenticatorType.'authenticator::rfidAuthenticate', array($rfid));
		        } catch(Exception $e){
		            $error=$e->getMessage();
		        }
		    } else {
		        $authenticated=call_user_func_array($authenticatorType.'authenticator::authenticate', array($username,$password));
		        if(!$authenticated){ 
		            $error='Username or password incorrect'; 
		        } else {
		            databaseauthenticator::registerRfidCard($rfid, $username);
		        }
		        
		    }
		} else if(empty($username) || empty($password)){
			$error='Username and password are required';
		} else {
			$authenticated=call_user_func_array($authenticatorType.'authenticator::authenticate', array($username,$password));
			if(!$authenticated){ $error='Username or password incorrect'; }
		}
		if($error){
			throw new AuthorizationRequiredException($error);
			//return false;
		} else {
			$user=user::getByName($username);
			$result=database::queryGetOne('SELECT isactive FROM user WHERE id=:id', array(':id'=>$user['id']));
			if(!$result['isactive']){
				throw new AuthorizationRequiredException('Your account is not active. See your administrator.');
			}
			self::generateCsrfToken();
			session::set('user',$user);
			session::set('userId',$user['id']);
			session::set('username',$username);
			session::set('lastAccess',time());
			session::refreshProjectPermissions();
			return array(
				'success'=>true,
				'username'=>$username,
			    'userid'=>$user['id'],
			    'isadmin'=>$user['isadmin'], //Used by login page if code and DB versions do not match
			    'sid'=>session::getSessionId(),
				'csrfToken'=>session::get("csrfToken"),
				'projectPermissions'=>session::get("projectPermissions"),
			);
		}
	}

    /**
     * @param $parameters
     * @return bool
     * @throws AuthorizationRequiredException
     */
	public static function validateCsrfToken($parameters){
		if(!isset($parameters['csrfToken'])){
			throw new AuthorizationRequiredException('CSRF token not supplied');
		} else if($parameters['csrfToken'] != session::get('csrfToken')){
			throw new AuthorizationRequiredException('CSRF Token Mismatch');
		}
		unset($parameters['csrfToken']);
		return true;
	}

    /**
     * @param $request
     * @return array
     */
	public static function logout($request){
		session::destroy();
		return array(
			'success'=>true,
			'loggedOut'=>true
		);
	}

    /**
     * @param $ids
     * @return array|null
     * @throws BadRequestException
     * @throws ServerException
     */
	private static function getProjects($ids){
		if(empty($ids)){ return null; }
		$inClause=implode(',', $ids);
		if(!preg_match('/^[0-9,]+$/', $inClause)){
			throw new BadRequestException('Bad project ID list passed to session::getProjects');
		}
		$inClause='id IN ('. $inClause .')';
		if(1==count($ids)){ $inClause='id='.$ids[0]; }
		$userId=(int)(session::getUserId());
		$sql='SELECT * FROM project WHERE isarchived=FALSE AND (owner='.$userId.' OR '.$inClause.') ';
		return database::queryGetAll($sql, array());
	}

    /**
     * @param bool $withDetails
     * @return array|null
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function getCreateProjects($withDetails=false){
		$perms=session::get('projectPermissions');
		if(!$withDetails){ return $perms['create']; }
		return session::getProjects($perms['create']);		
	}

    /**
     * @param bool $withDetails
     * @return array|null
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function getReadProjects($withDetails=false){
		$perms=session::get('projectPermissions');
		if(!$withDetails){ return $perms['read']; }
		return session::getProjects($perms['read']);		
	}

    /**
     * @param bool $withDetails
     * @return array|null
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function getUpdateProjects($withDetails=false){
		$perms=session::get('projectPermissions');
		if(!$withDetails){ return $perms['update']; }
		return session::getProjects($perms['update']);		
	}

    /**
     * @param bool $withDetails
     * @return array|null
     * @throws BadRequestException
     * @throws ServerException
     */
	public static function getDeleteProjects($withDetails=false){
		$perms=session::get('projectPermissions');
		if(!$withDetails){ return $perms['delete']; }
		return session::getProjects($perms['delete']);		
	}

    /**
     * @param null $accessType
     * @param bool $forceSharedProject
     * @return mixed
     * @throws NotFoundException
     * @throws ServerException
     * @throws BadRequestException
     * @throws BadRequestException
     */
	public static function getProjectPermissions($accessType=null,$forceSharedProject=false){
		$perms=session::get('projectPermissions');
		if($forceSharedProject){
		    $sharedProjectId=project::getSharedProjectId();
		    foreach($perms as $k=>$v){
		        if(!in_array($sharedProjectId, $perms[$k])){
    		        $perms[$k][]=$sharedProjectId;
		        }
		    }
		}
		if(null==$accessType){ return $perms; }
		if(!in_array($accessType, array('create','read','update','delete'))){
			throw new ServerException('Tried to get project permissions for unknown access type '.$accessType);
		}
		return $perms[$accessType];
	}


    /**
     * @throws ServerException
     */
	public static function refreshUserConfig(){
	    session::set('userConfig', null);
	    try {
    	    $userConfig=userconfig::getAll();
    	    session::set('userConfig', $userConfig);
	    } catch(BadRequestException $e){
	        //probably in installer and table doesn't exist.
	    }
	}

    /**
     * Generates a token for CSRF prevention.
     * @see https://www.owasp.org/index.php/PHP_CSRF_Guard
     * @return string
     */
	private static function generateCsrfToken(){
		if (function_exists("hash_algos") and in_array("sha512",hash_algos())){
			$token=hash("sha512",mt_rand(0,mt_getrandmax()));
		} else {
			$token=' ';
			for ($i=0;$i<128;++$i){
				$r=mt_rand(0,35);
				if ($r<26){
					$c=chr(ord('a')+$r);
				} else {
					$c=chr(ord('0')+$r-26);
				}
				$token.=$c;
			}
		}
		session::set('csrfToken', $token);
		return $token;
	}
	
	
}

class PhpSession {

    /**
     * PhpSession constructor.
     * @param null $sessionId
     */
    public function __construct($sessionId=null){
		if($sessionId){ session_id($sessionId); }
		session_start();
	}

    /**
     * @param $name
     * @return mixed|null
     */
	public function get($name){
		if(isset($_SESSION[$name])){
			return $_SESSION[$name];
		}
		return null;
	}

    /**
     * @param $name
     * @param $value
     */
	public function set($name, $value){
		$_SESSION[$name]=$value;
	}

    /**
     * @return string
     */
	public function getSessionId(){
		return session_id();		
	}

    /**
     *
     */
	public function destroy(){
		session_destroy();
	}
}

class DummySession {
	
	private $session;

    /**
     * DummySession constructor.
     */
	public function __construct(){
		$this->session=array();
	}

    /**
     * @param $name
     * @return mixed|null
     */
	public function get($name){
		if(isset($this->session[$name])){
			return $this->session[$name];
		} 
		return null;
	}

    /**
     * @param $name
     * @param $value
     */
	public function set($name, $value){
		$this->session[$name]=$value;
	}

    /**
     * @return string
     */
	public function getSessionId(){
		return 'DUMMYSESSION';		
	}

    /**
     *
     */
	public function destroy(){
		$this->session=null;
	}
}