<?php class basenote extends baseobject {

	protected static $fields=array(
			'name'=>validator::ANY, //actually required but is auto generated
			'text'=>validator::ANY,
			'userid'=>array(validator::REQUIRED, validator::INTEGER),
			'parentid'=>array(validator::REQUIRED),
	);
	
	protected static $helpTexts=array(
	);

    /**
     * @param string $key
     * @param string $value
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function getByProperty($key, $value, $request=array()){
        return static::getByProperties( array($key=>$value), $request);
	}

    public static function getByProperties($keyValuePairs,$request=array()){
        $keys=array_keys(self::getFieldValidations());
        $params=[];
        $sqlStatement='SELECT SQL_CALC_FOUND_ROWS baseobject.createtime AS createtime, user.fullname AS username, note.*
				FROM baseobject, note, user, project
				WHERE baseobject.id=note.id AND user.id=note.userid 
				AND note.projectid=project.id ';
        foreach ($keyValuePairs as $key=>$value){
            if(!in_array($key, $keys) &&'projectid'!=$key){
                throw new BadRequestException('Property '.$key.' not recognised on note');
            }
            if(database::$nullValue===$value){
                $sqlStatement.=' AND note.'.$key.' IS NULL ';
            } else {
                $sqlStatement.=' AND note.'.$key.'=:'.$key.' ';
                $params[':'.$key]=$value;
            }
        }
        $sqlStatement.=static::getProjectClause('read');
        $sqlStatement.='ORDER BY baseobject.createtime DESC';
        $sqlStatement.=database::getLimitClause($request);
        return database::queryGetAll($sqlStatement,$params);
    }

    /**
     * @param array $request
     * @return array|void
     * @throws BadRequestException
     */
	public static function getAll($request=array()){
		throw new BadRequestException('getAll not implemented on note');
	}

    /**
     * @param string $name
     * @return array|void
     * @throws BadRequestException
     */
	public static function getByName($name){
		throw new BadRequestException('getByName not implemented on note');
	}

    /**
     * @param array $request
     * @return array
     * @throws BadRequestException
     * @throws ForbiddenException
     * @throws NotFoundException
     * @throws ServerException
     */
	public static function create($request=array()){
        $request['userid']=session::getUserId();
	    if(database::$nullValue===$request['parentid']){
	        if(!isset($request['projectid'])){
	            throw new BadRequestException('Must specify projectid if parentid is '.database::$nullValue);
            }
            $request['name']='proj'.$request['projectid'].'_user'.$request['userid'].'_'.microtime();
        } else {
            $parent=baseobject::getById($request['parentid']);
            $request['projectid']=$parent['projectid'];
            $request['name']='obj'.$parent['id'].'_user'.$request['userid'].'_'.microtime();
        }
		return parent::create($request);
	}

}