<?php 

class databaseauthenticator implements authenticator {
	
	static function authenticate($username, $password){
		$result=database::queryGetOne('SELECT password FROM user WHERE name=:username', array(':username'=>$username));
		if(!$result){
			return false;
		}
        return password_verify($password, $result['password']);
	}
	
	static function rfidLoginAllowed(){
	   return (boolean)(config::get('auth_db_allow_rfid_login'));
	}

    /**
     * Returns the username of the user who previously registered the RFID card having the supplied code.
     * Note that, because the RFID codes are hashed, the supplied code must be checked against all of them. This does not scale well.
     *
     * @param $rfid
     * @return string The username associated with the RFID card
     * @throws AuthorizationRequiredException if RFID login is disabled, or if the card has not been registered.
     */
	static function rfidAuthenticate($rfid){
	    $username=null;
	    $allowRfidLogin=static::rfidLoginAllowed();
	    if(!$allowRfidLogin){
	        throw new AuthorizationRequiredException('RFID login disabled. See your administrator.');
	    }
	    $rfidUsers=database::queryGetAll("SELECT name, rfid FROM user WHERE rfid<>'' ", array());
	    if(!empty($rfidUsers)){
	        foreach($rfidUsers['rows'] as $row){
	            if(password_verify($rfid, $$row['rfid'])){
	                $username=$row['name'];
	                break;	                
	            }
	        }
	    }
	    if(empty($username)){
	        throw new AuthorizationRequiredException('Log in to register this card.');
	    }
	    return $username;
	}

    /**
     * @param $rfid
     * @param $username
     * @throws BadRequestException
     */
	static function registerRfidCard($rfid, $username){
	    if(empty($rfid)){
	        throw new BadRequestException("No RFID supplied to registerRfidCard");
	    }
	    $user=user::getByName($username);
	    if(!$user){
	        throw new BadRequestException("No user called ".$username);
	    }
	    $rfid=password_hash($rfid, PASSWORD_BCRYPT);
	    database::query('UPDATE user SET rfid=:rfid WHERE name=:username', array(
	        ':rfid'=>$rfid,
	        ':username'=>$username
	    ));
	}
	
}

