<?php class Log {

    const LOGLEVEL_DEBUG=1;
    const LOGLEVEL_INFO=2;
    const LOGLEVEL_WARN=3;
    const LOGLEVEL_ERROR=4;
    private static $logLevel;
    private static $logFileHandle;
    private static $inited=false;
    
    /**
     * Initiates logging.
     * @param string $logFilePath The file to append to (creating if needed), or empty to echo logs to output.
     * @param int $logLevel One of the constants Log::LOGLEVEL_DEBUG, Log::LOGLEVEL_INFO, Log::LOGLEVEL_WARN, Log::LOGLEVEL_ERROR.
     * @throws ServerException if the log file cannot be opened for appending.
     */
    public static function init($logLevel, $logFilePath=null){
        if(!empty($logFilePath)){
            static::$logFileHandle=@fopen($logFilePath,'a');
            if(!static::$logFileHandle){
                throw new ServerException('Could not open log file '.$logFilePath.' for appending.');
            }
        }
        static::$logLevel=$logLevel;
        static::$inited=true;
    }
    
    public static function getLogLevel(){
        return static::$logLevel;
    }
    
    public static function isInited(){
        return static::$inited;
    }

    /**
     * Writes the supplied message to the log, with level and GMT date/time, if the log level is equal to or higher than that specified in init().
     * @param int $logLevel The log level for this message.
     * @param string $message The message to log
     * @throws ServerException
     */
    public static function write($logLevel, $message){
        if(!static::$inited){ throw new ServerException('Log not init()ed.'); }
        if($logLevel<static::$logLevel){ return; }
        $labels=array(
            static::LOGLEVEL_DEBUG=>'DEBUG',
            static::LOGLEVEL_INFO =>'INFO ',
            static::LOGLEVEL_WARN =>'WARN ',
            static::LOGLEVEL_ERROR=>'ERROR',
        );
        $out=$labels[$logLevel].' '.gmdate('d M y H:i:s').' '.$message."\n";
        if(static::$logFileHandle){
            fwrite(static::$logFileHandle, $out);
            fflush(static::$logFileHandle);
        } else {
            echo $out;
        }
    }

    /**
     * Tidies up, closing the log file handle.
     */
    public static function end(){
        static::$inited=false;
        if(static::$logFileHandle){
            fflush(static::$logFileHandle);
            @fclose(static::$logFileHandle);
            static::$logFileHandle=null;
        }
    }

} 