<?php

function callDiffractionApi($args){
        Log::init(Log::LOGLEVEL_DEBUG, '/var/log/icebear/diffractionapi.log');

        if('diffraction'!=$args[0]){
                throw new ServerException('Diffraction API should not handle /api/'.$args[0]);
        }
        if(!isset($args[1]) || empty($args[1])){
                return getHighestSupportedVersion();
        }
        $version=$args[1];
        if(!preg_match('/^v[0-9_]+$/', $version)){
                throw new BadRequestException('Bad API version number');
        } else if(!file_exists(rtrim(__DIR__).'/'.$version.'/DiffractionAPI.class.php')){
                throw new BadRequestException('Diffraction API version number '.$version.' not supported');
        }
        include_once rtrim(__DIR__).'/'.$version.'/DiffractionAPI.class.php';
        if(!isset($args[2])){
            header('Content-Type: application/json');
            include_once(rtrim(__DIR__).'/'.$version.'/schema.json');
            exit;
        } else if('doc'==$args[2]){
            include_once(rtrim(__DIR__).'/schemadoc.php');
            exit;
        }

        if(isset($args[3]) && 'platetasklist'==$args[2]){
                $barcode=$args[3];
                Log::write(Log::LOGLEVEL_INFO,'Logging works');
                return DiffractionApi::encodePlateByBarcode($barcode,'array');
                Log::write(Log::LOGLEVEL_INFO,'After encode');
        } else if(isset($args[3]) && 'dewar'==$args[2]){
                $barcode=$args[3];
                return DiffractionApi::encodeDewarByBarcode($barcode,'array');
        }

        exit;
}

// @TODO return highest supported version
function getHighestSupportedVersion(){
        return array('latestVersion'=>'TODO');
}
