<?php

interface XraySourceInterface {
    
    /**
     * Constructor.
     * @param array|int $shipment An array representing a shipment, or a shipment ID
     */
    public function __construct($shipment);
    
    /**
     * Returns the supplied plate in serialized form suitable for submission to the X-ray source.
     * @param array|string $plate The plate, or its barcode. Note that, to avoid confusion with numeric barcodes, plate IDs SHOULD NOT be passed.
     * @return string The serialized shipment.
     */
    public static function getEncodedPlate($plate);

    /**
     * Returns the shipment in serialized form suitable for submission to the X-ray source.
     * @return string The serialized shipment.
     */
    public function getEncodedShipment();
    
    /**
     * Returns the response received from the X-ray source after calling submitShipment.
     * @return string The response to the shipment submission.
     */
    public function getResponse();
    
    /**
     * Returns a short message, suitable for display to the shipment submitter, indicating the result of submission.
     * @return string The userfriendly message.
     */
    public function getResultMessage();
    
    /**
     * Returns the HTML for a form to log into the remote X-ray source.
     * @return string The HTML for the login form.
     */
    public function getLoginForm();
    
/**
     * Checks whether we are authenticated at the remote service. Implementations may
     * choose to do this by sending a HEAD request, if supported at the remote end.
     * 
     * @return boolean true if we are authenticated, otherwise false.
     */
    public function testAuthenticated();
    
    /**
     * Authenticates at the remote service, using credentials provided by the IceBear user.
     * @param array $credentials The remote-service credentials
     * @return boolean true if authentication succeeds
     * @throws BadRequestException if authentication fails; see exception message for details.
     */
    public function authenticate($credentials);
    
    /**
     * Sends the shipment details to the X-ray source.
     * @return true if the shipment submission succeeded
     * @throws ServerException if the shipment submission failed; see exception message for details
     */
    public function submitShipment();
    
}


?>