<?php

class ESRFInterfaceV1 implements XraySourceInterface {
   
    private $shipment;
    private $destination;
    private $encodedShipment;
    private $response;
    private $message;
    
    function __construct($shipment, $request){
        if(!$shipment['id']){
            $shipment=shipment::getById($shipment);
        }
        $this->shipment=$shipment;        
        $this->destination=shipmentdestination::getById($shipment['shipmentdestinationid']);
    }

    public function getEncodedPlate($plate){
        throw new ServerException('Method encodePlate not supported on ESRFInterface');    
    }

    public function getEncodedShipment(){
        if(!empty($this->encodedShipment)){
            return $this->encodedShipment; 
        }
        $s=$this->shipment;
        $ret=array(
            "shippingName"=>$s['name'],
            "comments"=>"",
            "shippingType"=>"DewarTracking"
        );
        $dewars=array();
        $contents=containercontent::getByProperty('parent',$s['id']);
        if(empty($contents)){ 
            throw new BadRequestException('No dewars in shipment'); 
        }
        foreach($contents['rows'] as $c){
            $dewars[]=$this->encodeDewar($c['child']);
        }
        $ret['dewarVOs']=$dewars;
        return static::jsonEncodeArray($ret);
    }
    
    public function getResponse(){
        return $this->response;
    }
    
    public function getResultMessage(){
        return $this->message;
    }
    
    public function getLoginForm(){
        return '<form>LOGIN FORM</form>';
    }
    
    public function testAuthenticated(){
        //Make a HEAD request to the API URL
        return true; //or false    
    }
    
    public function authenticate($credentials){
        
    }
    
    public function submitShipment(){
        $shipmentData=$this->getEncodedShipment();
        $this->encodedShipment=$shipmentData;
        
        $output='';
        $shipmentFilename='shipment'.str_replace(' ','_',str_replace('.','_',microtime())).'.json';
        
        //Write shipment out to shipment[ID}_request.json
        //system call to python createShipment.py
        set_include_path(get_include_path() . PATH_SEPARATOR . 'C:\\Users\\edaniel\\AppData\\Local\\Programs\\Python\\Python37\\lib');
        $currdir=getcwd();
        chdir($_SERVER['DOCUMENT_ROOT'].'/../esrfshiptest/');
        file_put_contents($shipmentFilename, $shipmentData);
        system('python createShipment.py '.$shipmentFilename.' 2>&1', $output);
  //      unlink($shipmentFilename);
        chdir($currdir);        
        echo $output;
        //Write response out to shipment[ID}_response.json
        //parse  response for (Exception: )
        
        //if OK, return success, else fail
        
        
        //return true, or throw ServerException
        $this->response='{ "testResponse":"success" }';
        $this->message='Dummy shipment submission succeeded';
        return true;
    }
    
    private function encodeDewar($dewarId){
        $container=container::getById($dewarId);
        $dewar=array(
            'code'=>$container['name'],
            'type'=>'Dewar',
            'barcode'=>$container['name']
        );
        $contents=containercontent::getByProperties(array('parent'=>$dewarId, 'shipmentid'=>$this->shipment['id']));
        if(!$contents){
            $contents=containercontent::getByProperties(array('parent'=>$dewarId, 'shipmentid'=>database::$nullValue));
        }
        if(!$contents){
            throw new BadRequestException('No pucks in dewar '.$container['name']);
        }
        $pucks=array();
        foreach($contents['rows'] as $content){
            $pucks[]=$this->encodePuck($content['child']);
        }
        $dewar['containerVOs']=$pucks;
        return $dewar;
    }
    
    private function encodePuck($puckId){
        $container=container::getById($puckId);
        $puck=array(
            'code'=>$container['name'],
            'containerType'=>'Puck',
        );
        $contents=containercontent::getByProperties(array('parent'=>$puckId, 'shipmentid'=>$this->shipment['id']));
        if(!$contents){
            $contents=containercontent::getByProperties(array('parent'=>$puckId, 'shipmentid'=>database::$nullValue));
        }
        if(!$contents){
            throw new BadRequestException('No pins in puck '.$container['name']);
        }
        $pins=array();
        foreach($contents['rows'] as $content){
            $pins[]=$this->encodePin($content['child'], $content['position']);
        }
        $puck['sampleVOs']=$pins;
        return $puck;
    }
    
    private function encodePin($pinId, $positionInPuck){
        $container=container::getById($pinId);
        $contents=containercontent::getByProperties(array('parent'=>$pinId, 'shipmentid'=>$this->shipment['id']));
        if(!$contents){
            $contents=containercontent::getByProperties(array('parent'=>$pinId, 'shipmentid'=>database::$nullValue));
        }
        if(!$contents){
            throw new BadRequestException('No cryatal in pin '.$container['name']);
        }
        $contents=$contents['rows'];
        if(1!=count($contents)){
            throw new BadRequestException('Cannot handle multiple crystals in pin '.$container['name']);
        }
        $crystal=crystal::getbyid($contents[0]['child']);
        $diffractionRequests=crystal::getdiffractionrequests($crystal['id']);
        $dr=null;
        foreach($diffractionRequests as $d){
            if(empty($dr['shipmentid']) || $shipment['id']==$dr['shipmentid']){
                $dr=$d;
                break;
            }
        }
        if(!$dr){ throw new ServerException('No current diffractionrequest found for crystal '.$crystal['name'].' (ID '.$crystal['id'].')'); }
        $welldrop=welldrop::getById($crystal['welldropid']);
        if(empty($welldrop['constructid'])){
            throw new BadRequestException('Drop for crystal '.$crystal['name'].' has no protein construct. Cannot ship.');
        }
        $construct=construct::getById($welldrop['constructid']);
        $protein=protein::getById($construct['proteinid']);
        $proteinAcronym=$protein['proteinacronym'];
        if(empty($proteinAcronym)){
            throw new BadRequestException('Protein for crystal '.$crystal['name'].' has no protein acronym. Cannot ship.');
        }
        
        $pin=array(
            'diffractionPlanVO'=>array(
                'experimentKind'=>$dr['diffractiontype'],
                'observedresolution'=>$dr['observedresolution'],
                'minimalresolution'=>$dr['minimumresolution'],
                'requiredresolution'=>$dr['requiredresolution'],
            ),
            'crystalVO'=>array(
                'proteinVO'=>array(
                    'acronym'=>$proteinAcronym
                ),
                'spaceGroup'=>$crystal['spacegroup'],
                'cellA'=>$crystal['unitcella'],
                'cellB'=>$crystal['unitcellb'],
                'cellC'=>$crystal['unitcellc'],
                'cellAlpha'=>$crystal['unitcellalpha'],
                'cellBeta'=>$crystal['unitcellbeta'],
                'cellGamma'=>$crystal['unitcellgamma'],
                'comments'=>''
            ),
            'name'=>$crystal['name'],
            'code'=>$container['name'],
            'location'=>$positionInPuck,
            'comments'=>$dr['comment']
        );
        if(stripos($container['name'],'dummypin_')===false){
            $pin['code']=$container['name'];
        }
        return $pin;
    }
    
    private static function jsonEncodeArray(&$arr){
        $ret=json_encode($arr, JSON_PRETTY_PRINT);
        //strip out null fields
        $pattern = '/"[A-Za-z0-9]+":null/i';
        $replacement = '';
        $ret=preg_replace($pattern, $replacement, $ret);
        $ret=preg_replace('/,+/', ',', $ret); //Remove consecutive commas left after stripping null fields
        $ret=preg_replace('/\{,+\}/', '{}', $ret); //Remove stray commas from empty objects
        //force numeric values to be numbers in JSON
        $numericFields=array('cellA','cellB','cellC','cellAlpha','cellBeta','cellGamma', 
            'observedResolution','minimalResolution','requiredResolution','position'
        );
        $pattern = '/"('.implode('|',$numericFields).')":"([0-9.-]+)"/i';
        $replacement = '"$1":$2';
        $ret=preg_replace($pattern, $replacement, $ret);
        return $ret;
    }
}


?>